/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.image.renderable;

import io.github.mortuusars.exposure.client.image.Image;
import io.github.mortuusars.exposure.client.image.modifier.ImageModifier;
import io.github.mortuusars.exposure.client.image.renderable.RenderableImageIdentifier;
import java.util.function.Function;

public interface RenderableImage
extends Image {
    public static final RenderableImage EMPTY = new Instance(Image.EMPTY, new RenderableImageIdentifier("-empty"));
    public static final RenderableImage MISSING = new Instance(Image.MISSING, new RenderableImageIdentifier("-missing"));

    public Image getImage();

    public RenderableImageIdentifier getIdentifier();

    @Override
    default public boolean isEmpty() {
        return this.equals(EMPTY) || !this.getImage().equals(this) && this.getImage().isEmpty();
    }

    default public RenderableImage modifyWith(Function<Image, Image> transformFunction, String variant) {
        Image image = transformFunction.apply(this.getImage());
        RenderableImageIdentifier identifier = this.getIdentifier().appendVariant(variant);
        return new Instance(image, identifier);
    }

    default public RenderableImage modifyWith(ImageModifier modifier) {
        return this.modifyWith(modifier::modify, modifier.getIdentifier());
    }

    public static RenderableImage of(String id, Image image) {
        return new Instance(image, new RenderableImageIdentifier(id));
    }

    public static class Instance
    extends Image.Wrapped
    implements RenderableImage {
        private final RenderableImageIdentifier identifier;

        public Instance(Image image, RenderableImageIdentifier identifier) {
            super(image);
            this.identifier = identifier;
        }

        @Override
        public RenderableImageIdentifier getIdentifier() {
            return this.identifier;
        }
    }
}

